
/**
 ******************************************************************************
 *
 * @file        MG0404_BSP.c
 * @brief       MG0404 Board Support heafile. 
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/31
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef _MG0404_BSP_H
#define _MG0404_BSP_H

#ifdef __cplusplus
 extern "C" {
#endif


/* Includes ------------------------------------------------------------------*/
#include "Common.h"

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Exported macros -----------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* Private defines -----------------------------------------------------------*/
#define LCD_RSTN_Pin            GPIO_Pin_4
#define LCD_RSTN_Mode           GPIO_MODE_PUSHPULL_O
#define LCD_RSTN_AFS            0
#define LCD_RSTN_Port           IOMB

#define LCD1st_D0_Pin           GPIO_Pin_12
#define LCD1st_D1_Pin           GPIO_Pin_11
#define LCD1st_D2_Pin           GPIO_Pin_10
#define LCD1st_D3_Pin           GPIO_Pin_9
#define LCD1st_D4_Pin           GPIO_Pin_8
#define LCD1st_D5_Pin           GPIO_Pin_3
#define LCD1st_D6_Pin           GPIO_Pin_2
#define LCD1st_D7_Pin           GPIO_Pin_1
#define LCD1st_D0_7_Mode        GPIO_MODE_DIGITAL_I
#define LCD1st_D0_7_AFS         8
#define LCD1st_D0_7_Port        IOMC

#define LCD1st_D8_Pin           GPIO_Pin_15
#define LCD1st_D9_Pin           GPIO_Pin_14
#define LCD1st_D10_Pin          GPIO_Pin_13
#define LCD1st_D11_Pin          GPIO_Pin_12
#define LCD1st_D12_Pin          GPIO_Pin_11
#define LCD1st_D13_Pin          GPIO_Pin_10
#define LCD1st_D14_Pin          GPIO_Pin_9
#define LCD1st_D15_Pin          GPIO_Pin_8
#define LCD1st_D8_15_Mode       GPIO_MODE_DIGITAL_I
#define LCD1st_D8_15_AFS        8
#define LCD1st_D8_15_Port       IOMB

#define LCD1st_RD_Pin           GPIO_Pin_5
#define LCD1st_WR_Pin           GPIO_Pin_6
#define LCD1st_CS_Pin           GPIO_Pin_7
#define LCD1st_CTL_Mode         GPIO_MODE_PUSHPULL_O
#define LCD1st_CTL_AFS          8
#define LCD1st_CTL_Port         IOMB

#define LCD1st_RS_Pin           GPIO_Pin_7
#define LCD1st_RS_Mode          GPIO_MODE_PUSHPULL_O
#define LCD1st_RS_AFS           0
#define LCD1st_RS_Port          IOMC

#define LCD1st_BL_Pin           GPIO_Pin_8
#define LCD1st_BL_Mode          GPIO_MODE_PUSHPULL_O
#define LCD1st_BL_AFS           0
#define LCD1st_BL_Port          IOME

//-------------------------------------
#define LCD2nd_URT0SPI_SDI_Pin  GPIO_Pin_4
#define LCD2nd_URT0SPI_SDI_Mode GPIO_MODE_DIGITAL_I

#define LCD2nd_URT0SPI_SDO_Pin  GPIO_Pin_5
#define LCD2nd_URT0SPI_SCK_Pin  GPIO_Pin_6
#define LCD2nd_URT0SPI_CS2_Pin  GPIO_Pin_7
#define LCD2nd_URT0SPI_Mode     GPIO_MODE_PUSHPULL_O
#define LCD2nd_URT0SPI_AFS      11
#define LCD2nd_URT0SPI_Port     IOMA

#define LCD2nd_DC_Pin           GPIO_Pin_7
#define LCD2nd_DC_Mode          GPIO_MODE_PUSHPULL_O
#define LCD2nd_DC_AFS           0
#define LCD2nd_DC_Port          IOMC

#define LCD2nd_BL_Pin           GPIO_Pin_9
#define LCD2nd_BL_Mode          GPIO_MODE_PUSHPULL_O
#define LCD2nd_BL_AFS           0
#define LCD2nd_BL_Port          IOME

//-------------------------------------
#define USB_DM_Pin              GPIO_Pin_4
#define USB_DP_Pin              GPIO_Pin_5
#define USB_DET_Pin             GPIO_Pin_6
#define USB_DET_Mode            GPIO_MODE_DIGITAL_I
#define USB_DET_AFS             0
#define USB_Port                IOMD

//-------------------------------------
#define FLASH_SPI0_CEN_Pin      GPIO_Pin_0
#define FLASH_SPI0_SCK_Pin      GPIO_Pin_1
#define FLASH_SPI0_DO_Pin       GPIO_Pin_2
#define FLASH_SPI0_D3_Pin       GPIO_Pin_3

#define FLASH_SPI0_D2_Pin       GPIO_Pin_8
#define FLASH_SPI0_DI_Pin       GPIO_Pin_7

#define FLASH_SPI0_DI_Mode      GPIO_MODE_DIGITAL_I
#define FLASH_SPI0_Mode         GPIO_MODE_PUSHPULL_O

#define FLASH_SPI0_CEN_AFS      0
#define FLASH_SPI0_AFS          7
#define FLASH_SPI0_AFS_B        5

#define FLASH_SPI0_Port         IOMD

//-------------------------------------
#define BLE_SPI_DI_Pin          GPIO_Pin_1
#define BLE_SPI_DI_Mode         GPIO_MODE_DIGITAL_I

#define BLE_SPI_CSN_Pin         GPIO_Pin_0
#define BLE_SPI_SCK_Pin         GPIO_Pin_2
#define BLE_SPI_DO_Pin          GPIO_Pin_3
#define BLE_SPI_Mode            GPIO_MODE_PUSHPULL_O
#define BLE_SPI_AFS             7
#define BLE_SPI_Port            IOMB

#define BLE_IRQ_EXIC_Pin        GPIO_Pin_1
#define BLE_IRQ_EXIC_Mode       GPIO_MODE_DIGITAL_I
#define BLE_IRQ_EXIC_AFS        0
#define BLE_IRQ_EXIC_Port       IOMB

//-------------------------------------
#define RGBLED1st_TM36_R_Pin    GPIO_Pin_0
#define RGBLED1st_TM36_G_Pin    GPIO_Pin_1
#define RGBLED1st_TM36_B_Pin    GPIO_Pin_2
#define RGBLED1st_TM36_Mode     GPIO_MODE_PUSHPULL_O
#define RGBLED1st_TM36_AFS      10
#define RGBLED1st_TM36_Port     IOMA

#define RGBLED2nd_TM36_R_Pin    GPIO_Pin_11
#define RGBLED2nd_TM36_G_Pin    GPIO_Pin_12
#define RGBLED2nd_TM36_B_Pin    GPIO_Pin_13
#define RGBLED2nd_TM36_Mode     GPIO_MODE_PUSHPULL_O
#define RGBLED2nd_TM36_AFS      0
#define RGBLED2nd_TM36_Port     IOMD

//-------------------------------------
#define EEPROM_I2C1_SCL_Pin     GPIO_Pin_2
#define EEPROM_I2C1_SDA_Pin     GPIO_Pin_3
#define EEPROM_I2C1_Mode        GPIO_MODE_OPENDRAIN_O
#define EEPROM_I2C1_AFS         2
#define EEPROM_I2C1_Port        IOME

//-------------------------------------
#define AUDIO_DAC_OUTL_Pin      GPIO_Pin_2
#define AUDIO_DAC_OUTR_Pin      GPIO_Pin_3
#define AUDIO_DAC_Mode          GPIO_MODE_ANALOG_IO
#define AUDIO_DAC_AFS           0
#define AUDIO_DAC_Port          IOMB

//-------------------------------------
#define AUDIO_ADC_INR_Pin       GPIO_Pin_8
#define AUDIO_ADC_INL_Pin       GPIO_Pin_9
#define AUDIO_ADC_Mode          GPIO_MODE_ANALOG_IO
#define AUDIO_ADC_AFS           0
#define AUDIO_ADC_Port          IOMA

//-------------------------------------
#define EC11_TM36_A_Pin         GPIO_Pin_12
#define EC11_TM36_B_Pin         GPIO_Pin_13
#define EC11_TM36_Mode          GPIO_MODE_DIGITAL_I
#define EC11_TM36_AFS           6

#define EC11_EXIC_SW_Pin        GPIO_Pin_14
#define EC11_EXIC_Mode          GPIO_MODE_ANALOG_IO
#define EC11_EXIC_AFS           0

#define EC11_TM36_Port          IOMA

//-------------------------------------
#define IR_APB_TX_Pin           GPIO_Pin_15
#define IR_APB_TX_Mode          GPIO_MODE_PUSHPULL_O
#define IR_APB_TX_AFS           3

#define IR_APB_RX_Pin           GPIO_Pin_14
#define IR_APB_RX_Mode          GPIO_MODE_DIGITAL_I
#define IR_APB_RX_AFS           0

#define IR_APB_Port             IOMD

//-------------------------------------
#define URT4_TX_Pin             GPIO_Pin_0
#define URT4_RX_Pin             GPIO_Pin_1
#define URT4_TX_Mode            GPIO_MODE_PUSHPULL_O
#define URT4_RX_Mode            GPIO_MODE_DIGITAL_I
#define URT4_AFS                11
#define URT4_Port               IOME

//-------------------------------------
#define ARGBLED_URT_OUT_Pin     GPIO_Pin_0
#define ARGBLED_URT_OUT_Mode    GPIO_MODE_PUSHPULL_O
#define ARGBLED_URT_OUT_AFS     0
#define ARGBLED_URT_OUT_Port    IOMA

//-------------------------------------
#define CLKOUT_ICKO_Pin         GPIO_Pin_0
#define CLKOUT_ICKO_Mode        GPIO_MODE_PUSHPULL_O
#define CLKOUT_ICKO_AFS         1
#define CLKOUT_ICKO_Port        IOMC

/* Private constants ---------------------------------------------------------*/
/* Private macros ------------------------------------------------------------*/
/* Private Functions ---------------------------------------------------------*/

void BSP_Init(void);

#ifdef __cplusplus
}
#endif

#endif /* end _MG0402_BSP_H */


